COMMENT Syntax for Panel (a) of Table 14 3, Loglinear Model, copyright by Robert B. Smith, 2011.

USE ALL.
COMPUTE filter_$=(surg = 1).
VARIABLE LABEL filter_$ 'surg = 1 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

HILOGLINEAR
  precert(0 1) miamihsp(0 1) comps(0 1)  /CWEIGHT=count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .


COMMENT Syntax for Panel (b) of Table 14 3, Loglinear Model.

USE ALL.
COMPUTE filter_$=(surg = 0).
VARIABLE LABEL filter_$ 'surg = 0 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

HILOGLINEAR
  precert(0 1) miamihsp(0 1) comps(0 1)  /CWEIGHT=count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN .




COMMENT Syntax across Panel (a) and Panel (b) of Table 14 3, Loglinear Model.

FILTER OFF.
USE ALL.
EXECUTE .

HILOGLINEAR
  surg(0 1) precert(0 1) miamihsp(0 1) comps(0 1)  /CWEIGHT=count /METHOD=BACKWARD
  /CRITERIA MAXSTEPS(10) P(.05) ITERATION(20) DELTA(.5)
  /PRINT=FREQ RESID ASSOCIATION ESTIM
  /DESIGN.
SAVE OUTFILE='C:\SPSSCodeforBook\DataTable10.3.sav'
 /COMPRESSED.



COMMENT  The SAS syntax for this table is also available.


